import {HOTELS_BASE_API} from 'projects/depreacted/hotels/constants/hotelsAPI';

import IGetCrossSaleHotelsRequestParamsV1 from 'server/api/HotelsCrossSaleApi/types/IGetCrossSaleHotelsRequestParamsV1';
import IGetCrossSaleHotelsResponseV1 from 'server/api/HotelsCrossSaleApi/types/IGetCrossSaleHotelsResponseV1';
import IGetCrossSaleHotelsRequestParamsV3 from 'server/api/HotelsCrossSaleApi/types/IGetCrossSaleHotelsRequestParamsV3';
import IGetCrossSaleHotelsResponseV3 from 'server/api/HotelsCrossSaleApi/types/IGetCrossSaleHotelsResponseV3';

import {BrowserHttpClient} from 'utilities/browserHttpClient/BrowserHttpClient';

import {IHotelsCrossSaleService} from 'server/services/HotelsServices/HotelsCrossSaleService';

export class BrowserHotelsCrossSaleProvider
    extends BrowserHttpClient
    implements IHotelsCrossSaleService
{
    constructor() {
        super({baseURL: HOTELS_BASE_API});
    }

    getCrossSaleHotelsV1 = async (
        params: IGetCrossSaleHotelsRequestParamsV1,
    ): Promise<IGetCrossSaleHotelsResponseV1> => {
        return this.get<IGetCrossSaleHotelsResponseV1>(
            `/getCrossSaleHotelsV1`,
            {
                params,
            },
        );
    };

    getCrossSaleHotelsV3 = async (
        params: IGetCrossSaleHotelsRequestParamsV3,
    ): Promise<IGetCrossSaleHotelsResponseV3> => {
        return this.get<IGetCrossSaleHotelsResponseV3>(
            `/getCrossSaleHotelsV3`,
            {
                params,
            },
        );
    };
}

export const browserHotelsCrossSaleProvider =
    new BrowserHotelsCrossSaleProvider();
