import {
    HOTELS_BASE_API,
    HOTEL_INFO,
    LEGACY_HOTEL_INFO,
    HOTEL_IMAGES,
    HOTEL_REVIEWS,
    ADD_HOTEL_REVIEW,
    EDIT_HOTEL_REVIEW,
    HOTEL_OFFERS,
    SIMILAR_HOTELS,
    HOTEL_REVIEW_REACTION,
    DELETE_HOTEL_REVIEW,
    UPLOAD_HOTEL_REVIEW_IMAGE,
    DELETE_HOTEL_REVIEW_IMAGES,
} from 'projects/depreacted/hotels/constants/hotelsAPI';

import {
    ILegacyHotelInfoRequestParams,
    ILegacyHotelInfoResponse,
} from 'server/api/HotelSearchAPI/types/ILegacyHotelInfo';
import {
    IHotelInfoRequestParams,
    IHotelInfo,
} from 'server/api/HotelSearchAPI/types/IHotelInfo';
import {
    IHotelImages,
    IHotelImagesRequestParams,
} from 'server/api/HotelSearchAPI/types/IHotelImages';
import {
    IHotelReviewsInfo,
    IHotelReviewsInfoRequestParams,
} from 'server/api/HotelSearchAPI/types/IHotelReviews';
import {
    IHotelOffersInfo,
    IHotelOffersInfoRequestParams,
} from 'server/api/HotelSearchAPI/types/IOffersInfo';
import {
    IHotelReviewReactionResponse,
    IHotelReviewReactionRequestParams,
} from 'server/api/HotelSearchAPI/types/IHotelReviewReaction';
import {
    ISimilarHotelsInfo,
    ISimilarHotelsInfoRequestParams,
} from 'server/api/HotelSearchAPI/types/ISimilarHotels';
import {
    IAddHotelReviewRequest,
    IAddHotelReviewResponse,
} from 'server/api/HotelSearchAPI/types/IAddHotelReview';
import {
    IEditHotelReviewRequest,
    IEditHotelReviewResponse,
} from 'server/api/HotelSearchAPI/types/IEditHotelReview';
import {
    IDeleteHotelReviewRequest,
    IDeleteHotelReviewResponse,
} from 'server/api/HotelSearchAPI/types/IDeleteHotelReview';
import {
    IUploadHotelReviewImageRequest,
    IUploadHotelReviewImageResponse,
} from 'server/api/HotelSearchAPI/types/IUploadHotelReviewImage';
import {
    IDeleteHotelReviewImagesRequestBody,
    IDeleteHotelReviewImagesRequestQuery,
    IDeleteHotelReviewImagesResponse,
} from 'server/api/HotelSearchAPI/types/IDeleteHotelReviewImages';

import {BrowserHttpClient} from 'utilities/browserHttpClient/BrowserHttpClient';

import {IHotelSearchService} from 'server/services/HotelsServices/HotelSearchService';

export class BrowserHotelSearchProvider
    extends BrowserHttpClient
    implements IHotelSearchService
{
    constructor() {
        super({baseURL: HOTELS_BASE_API});
    }

    getLegacyHotelInfo = (
        searchParams: ILegacyHotelInfoRequestParams,
    ): Promise<ILegacyHotelInfoResponse> =>
        this.get<ILegacyHotelInfoResponse>(LEGACY_HOTEL_INFO, {
            params: searchParams,
        });

    getHotelInfo = async (
        searchParams: IHotelInfoRequestParams,
    ): Promise<IHotelInfo> => {
        return this.get<IHotelInfo>(HOTEL_INFO, {
            params: searchParams,
        });
    };

    getHotelImages = (
        imagesParams: IHotelImagesRequestParams,
    ): Promise<IHotelImages> =>
        this.get<IHotelImages>(HOTEL_IMAGES, {
            params: imagesParams,
        });

    getHotelReviews = (
        reviewsParams: IHotelReviewsInfoRequestParams,
    ): Promise<IHotelReviewsInfo> =>
        this.get<IHotelReviewsInfo>(HOTEL_REVIEWS, {
            params: reviewsParams,
        });

    addHotelReview = (
        request: IAddHotelReviewRequest,
    ): Promise<IAddHotelReviewResponse> =>
        this.post<IAddHotelReviewResponse>(ADD_HOTEL_REVIEW, request);

    editHotelReview = (
        request: IEditHotelReviewRequest,
    ): Promise<IEditHotelReviewResponse> =>
        this.post<IEditHotelReviewResponse>(EDIT_HOTEL_REVIEW, request);

    deleteHotelReview = (
        request: IDeleteHotelReviewRequest,
    ): Promise<IDeleteHotelReviewResponse> =>
        this.post<IDeleteHotelReviewResponse>(DELETE_HOTEL_REVIEW, request);

    uploadHotelReviewImage = (
        formData: FormData,
        params: IUploadHotelReviewImageRequest,
    ): Promise<IUploadHotelReviewImageResponse> =>
        this.post<IUploadHotelReviewImageResponse>(
            UPLOAD_HOTEL_REVIEW_IMAGE,
            formData,
            {
                params,
            },
        );

    proxyUploadHotelReviewImage(): Promise<IUploadHotelReviewImageResponse> {
        // прокси нужно на нашем сервере чтобы проксировать картинки в бекенд
        throw new Error('Not implemented (only for server)');
    }

    deleteHotelReviewImages = (
        params: IDeleteHotelReviewImagesRequestQuery,
        request: IDeleteHotelReviewImagesRequestBody,
    ): Promise<IDeleteHotelReviewImagesResponse> =>
        this.post<IDeleteHotelReviewImagesResponse>(
            DELETE_HOTEL_REVIEW_IMAGES,
            request,
            {
                params,
            },
        );

    getHotelOffers = async (
        offersParams: IHotelOffersInfoRequestParams,
    ): Promise<IHotelOffersInfo> => {
        return this.get<IHotelOffersInfo>(HOTEL_OFFERS, {
            params: offersParams,
        });
    };

    getSimilarHotels = async (
        similarHotelsParams: ISimilarHotelsInfoRequestParams,
    ): Promise<ISimilarHotelsInfo> => {
        return this.get<ISimilarHotelsInfo>(SIMILAR_HOTELS, {
            params: similarHotelsParams,
        });
    };

    setHotelReviewReaction = (
        reaction: IHotelReviewReactionRequestParams,
    ): Promise<IHotelReviewReactionResponse> =>
        this.post<IHotelReviewReactionResponse>(HOTEL_REVIEW_REACTION, null, {
            params: reaction,
        });
}

export const browserHotelSearchProvider = new BrowserHotelSearchProvider();
