import {IHotelsFavoritesService} from 'server/services/HotelsServices/HotelsFavoritesService';
import {IDependencies} from 'server/getContainerConfig';

import {getProvider} from 'serviceProvider/core';

import {browserHotelsFavoritesProvider} from './browserHotelsFavoritesProvider';

export const hotelsFavorites = {
    provider(container?: IDependencies): IHotelsFavoritesService {
        return getProvider<'hotelsFavoritesService', IHotelsFavoritesService>(
            browserHotelsFavoritesProvider,
            'hotelsFavoritesService',
        )(container);
    },
};
