import {
    INotifierPromoConfig,
    INotifierSubscribeApiParams,
} from 'server/api/NotifierApi/types';
import {ESubscriptionVerticalName} from 'types/subscription/ESubscriptionVerticalName';

import {createAxiosRetryConfig} from 'utilities/api/createAxiosRetryConfig';
import {BrowserHttpClient} from 'utilities/browserHttpClient/BrowserHttpClient';

import {INotifierService} from 'server/services/NotifierService/NotifierService';

class NotifierBrowserProvider
    extends BrowserHttpClient
    implements INotifierService
{
    constructor() {
        super({baseURL: '/api/common/notifier'});
    }

    getStatus = (email: string): Promise<boolean | null> =>
        this.get<boolean | null>('getStatus', {
            'axios-retry': createAxiosRetryConfig(),
            params: {
                email,
            },
        });

    getPromoConfig = (
        vertical: ESubscriptionVerticalName,
        email?: string,
    ): Promise<INotifierPromoConfig> =>
        this.get<INotifierPromoConfig>('getPromoConfig', {
            params: {
                vertical,
                email,
            },
        });

    subscribe = (
        params: Omit<INotifierSubscribeApiParams, 'authType' | 'authValue'>,
    ): Promise<void> => this.post('subscribe', params);

    unsubscribe = (id: string): Promise<void> =>
        this.get<void>('unsubscribe', {
            'axios-retry': createAxiosRetryConfig(),
            params: {
                id,
            },
        });
}

export const notifierBrowserProvider = new NotifierBrowserProvider();
