import {ISeoExpsApiGetModificationsParams} from 'server/api/SeoExpsApi/types/ISeoExpsApiGetModificationsParams';
import {TSeoExpsApiGetModificationsResponse} from 'server/api/SeoExpsApi/types/TSeoExpsApiGetModificationsResponse';

import {BrowserHttpClient} from 'utilities/browserHttpClient/BrowserHttpClient';

import {ISeoExpsService} from 'server/services/SeoExpsService/SeoExpsService';

export class BrowserSeoExpsProvider
    extends BrowserHttpClient
    implements ISeoExpsService
{
    constructor() {
        super({baseURL: '/api/seoExps/'});
    }

    getModifications = (
        params: ISeoExpsApiGetModificationsParams,
    ): Promise<TSeoExpsApiGetModificationsResponse> => {
        return this.get<TSeoExpsApiGetModificationsResponse>(
            'getModifications',
            {params},
        );
    };
}

export const browserSeoExpsProvider = new BrowserSeoExpsProvider();
