import {IDependencies} from 'server/getContainerConfig';
import {ISeoExpsService} from 'server/services/SeoExpsService/SeoExpsService';

import {getProvider} from 'serviceProvider/core';
import {browserSeoExpsProvider} from 'serviceProvider/seoExps/browserSeoExpsProvider';

export const seoExpsProvider = {
    provider(container?: IDependencies): ISeoExpsService {
        return getProvider<'seoExpsService', ISeoExpsService>(
            browserSeoExpsProvider,
            'seoExpsService',
        )(container);
    },
};
