import preval from 'preval.macro';

// Load and parse on the server side
const colorsVars: Record<string, string> = preval`
  const fs = require('fs');
  const path = require('path');
  const { extractVars } = require('string-extract-sass-vars');

  const colorsPath = path.resolve(__dirname, '..', '..', '..', 'colors.scss');
  const colorsText = fs.readFileSync(colorsPath, 'utf8');

  module.exports = extractVars(colorsText);
`;

export default colorsVars;
