import hexToRgb from './hexToRgb';

export default function resolveRgba(value: string): string {
    const rgbaRegExp = /rgba\s*\(\s*(#[\d\w]+)/;
    const match = value.match(rgbaRegExp);

    if (!match?.[1]) {
        return value;
    }

    const rgb = hexToRgb(match[1]);

    if (!rgb) {
        return value;
    }

    const replaced = value.replace(rgbaRegExp, `rgba(${rgb.join(', ')}`);

    return resolveRgba(replaced);
}
