/**
 * Заменяет вхождение переменных в строке
 * @param value - значение которое содежит или не содержит переменные переменные
 * @param variables - словать переменных
 */

export default function resolveVariables(
    value: string,
    variables: Record<string, string>,
): string {
    const variablesInValue = findVariables(value);

    return variablesInValue.reduce((acc, variable) => {
        const variableName = variable.replace('$', '');
        const variableValue = variables[variableName];

        if (!variableValue) {
            return acc;
        }

        const resolvedVariableValue = resolveVariables(
            variableValue,
            variables,
        );

        return acc.replace(variable, resolvedVariableValue);
    }, value);
}

function findVariables(value: string): string[] {
    return value.match(/\$[\w-]+/g) ?? [];
}
