/**
 * Описание PointKey (уникальные id для объектов) для стран, городов и станций
 */

import TUniqueString from 'types/TUniqueString';

/**
 * Идентификатор страны.
 * Строка с префиксом 'l'. Например 'l52'.
 */
export type TCountryKey = TUniqueString<'countryKey'>;

/**
 * Идентификатор населенного пункта.
 * Строка с префиксом 'c'. Например 'c52'.
 */
export type TSettlementKey = TUniqueString<'settlementKey'>;

/**
 * Идентификатор станции.
 * Строка с префиксом 's'. Например 's1084'.
 */
export type TStationKey = TUniqueString<'stationKey'>;

/**
 * Идентификатор региона.
 * Строка с префиксом 'r'. Например 'r977'.
 */
export type TRegionKey = TUniqueString<'regionKey'>;

/**
 * Идентификатор любой геоточки.
 */
export type TPointKey = TStationKey | TSettlementKey | TRegionKey | TCountryKey;
