import {
    IHotelLinkBlock,
    IRegionLinkBlock,
    ISearchHotelsLinkBlock,
} from 'types/hotels/geoRegion/IGeoRegionInfo';
import {
    ILandingLinkBlock,
    ISearchAviaLinkBlock,
} from 'types/avia/landing/IAviaLanding';

import IPrice from 'utilities/currency/PriceInterface';

export enum EPlainTextStyle {
    bold = 'bold',
    italic = 'italic',
}

export enum ETextBlocksType {
    searchFormBlock = 'ISearchFormBlock',
    hotelsBlock = 'IHotelsBlock',
    sectionTextBlock = 'ISectionTextBlock',
    subSectionTextBlock = 'ISubSectionTextBlock',
    textBlock = 'ITextBlock',
    spoilerBlock = 'ISpoilerBlock',
    priceTextBlock = 'IPriceTextBlock',
    plainTextBlock = 'IPlainTextBlock',
    geoLinkGroupBlock = 'IGeoLinkGroupBlock',

    externalLinkBlock = 'IExternalLinkBlock',

    /* Специфичные для отелей ссылки */
    regionLinkBlock = 'IRegionLinkBlock',
    searchHotelsLinkBlock = 'ISearchHotelsLinkBlock',
    hotelLinkBlock = 'IHotelLinkBlock',

    /* Специфичные для авиа ссылки */
    searchAviaLinkBlock = 'ISearchAviaLinkBlock',
    routeLinkBlock = 'IRouteLinkBlock',
}

export type TSectionTextChildBlock =
    | ISubSectionTextBlock
    | ISpoilerBlock
    | IGeoLinkGroupBlock
    | ITextBlock;

export interface ISectionTextBlock {
    type: ETextBlocksType.sectionTextBlock;
    data: {
        title?: string;
        text?: string;
    };
    children: TSectionTextChildBlock[];
}

/* SubSectionText block(h3) */
export interface ISubSectionTextBlock {
    type: ETextBlocksType.subSectionTextBlock;
    data: {
        title?: string;
    };
    children: ITextBlock[];
}

/* Spoiler block */
export interface ISpoilerBlock {
    type: ETextBlocksType.spoilerBlock;
    data: {
        title: string;
        description: ITextBlock;
    };
}

/* Link blocks */
export type TLinkTextBlock =
    | IExternalLinkBlock
    | IHotelLinkBlock
    | IRegionLinkBlock
    | ISearchHotelsLinkBlock
    | ISearchAviaLinkBlock
    | ILandingLinkBlock;

/* Text block */
export type TTextChildBlock =
    | IPlainTextBlock
    | TLinkTextBlock
    | IPriceTextBlock;

export interface ITextBlock {
    type: ETextBlocksType.textBlock;
    children: TTextChildBlock[];
}

export interface IExternalLinkBlock {
    type: ETextBlocksType.externalLinkBlock;
    data: {
        text: string;
        url: string;
    };
}

/* PriceText block */
export interface IPriceTextBlock {
    type: ETextBlocksType.priceTextBlock;
    data: {
        price: IPrice;
    };
}

/* PlainText block */
export interface IPlainTextBlock {
    type: ETextBlocksType.plainTextBlock;
    data: {
        text: string;
        styles?: EPlainTextStyle[];
    };
}

/* LinkGroup block */
export interface IGeoLinkGroupBlock {
    type: ETextBlocksType.geoLinkGroupBlock;
    data: {
        mainLink: TLinkTextBlock;
        additionalLink?: TLinkTextBlock;
    };
}
