import {ILinksListBlock} from 'types/common/seoPages/ILinksListBlock';
import {TTransportProjectName} from 'types/common/TTransportProjectName';
import {ECommonLandingBlockType} from 'types/common/seoPages/ECommonLandingBlockType';

import IPrice from 'utilities/currency/PriceInterface';

export interface ITransportRoute {
    transport: TTransportProjectName;
    /**
     * Слаг для пункта отправления
     */
    fromSlug: string;
    /**
     * Слаг для пункта прибытия
     */
    toSlug: string;
    /**
     * Текст ссылки на страницу направления
     */
    text: string;
    /**
     * Минимальная цена по направлению (если известна)
     */
    minPrice?: IPrice;
}

export interface ITransportRoutesBlock {
    type: ECommonLandingBlockType.TRANSPORT_ROUTES;
    data: ILinksListBlock<ITransportRoute>;
}
