import {EFieldName} from 'components/BookingPassengerForm/constants/fieldNames';

import {EYandexPlusApplicationMode} from 'types/hotels/offer/IHotelOffer';

import {TBookingContacts} from 'components/BookingContactsForm/BookingContactsForm';
import {IFormDocument} from 'components/BookingPassengerForm/BookingPassengerForm';
import {EBookPriceInfoFieldName} from 'projects/depreacted/hotels/components/BookPriceInfo/BookPriceInfo';

export interface IBookContacts extends TBookingContacts {
    /**
     * Вспомогательный ключ для валидаций. Не дает finalForm очистить пустой объект.
     * Нужен для сохранения структуры полей
     */
    validationKey: 'contacts';
}

export enum EBookGuestFieldName {
    index = 'index',
}

export interface IBookGuest
    extends Pick<IFormDocument, EFieldName.firstName | EFieldName.lastName> {
    [EBookGuestFieldName.index]?: number;
}

export interface IStorageBookGuest extends IBookGuest {
    ageGroup: 'adult' | 'children';
}

export interface IBookPriceInfo {
    [EBookPriceInfoFieldName.plusMode]: EYandexPlusApplicationMode;
    /**
     * Никак не используется = оторвано на бэкенде,
     * оставлено на случай включения без договоренности с фронтом,
     * т.к. API подразумевает такую возможность
     */
    [EBookPriceInfoFieldName.bedsGroupId]: string;
    [EBookPriceInfoFieldName.useDeferredPayments]: boolean;
}

export enum EFormGroup {
    adult = 'adult',
    children = 'children',
    contacts = 'contacts',
    priceInfo = 'priceInfo',
}

export interface IBookChildGuest extends IBookGuest {
    age: number;
}

export interface IBookFormValues {
    [EFormGroup.adult]?: IBookGuest[];
    [EFormGroup.children]?: IBookChildGuest[];
    [EFormGroup.contacts]?: IBookContacts;
    [EFormGroup.priceInfo]?: IBookPriceInfo;
}
