import {BookingStatusesType} from 'server/api/HotelsBookAPI/constants/hotelsBookingStatuses';
import {StatusCodes} from 'server/api/HotelsBookAPI/constants/statusCodes';

import {
    IBookOrderOfferInfo,
    IBookOffer,
} from 'server/api/HotelsBookAPI/types/IBookOffer';
import ICustomerUser from 'server/api/HotelsBookAPI/types/ICustomerUser';
import {
    IBookFormValues,
    IBookPriceInfo,
} from 'types/hotels/book/IBookFormValues';

import {
    IBaseSuccessResponse,
    IBaseErrorResponse,
} from 'server/controllers/hotelsApiController/HotelsBaseController';

import {IAppliedPromoCampaigns} from '../offer/IHotelOffer';

/* Request */

export interface IBookUserSelect extends IBookPriceInfo {}

export interface ICreateOrderRequest {
    offerOrderInfo: IBookOrderOfferInfo;
    formValues: IBookFormValues;
    promoCodes?: string[];
    appliedPromoCampaigns?: IAppliedPromoCampaigns;
    paymentTestContextToken?: string;
}

export interface ICustomerCreateOrderRequest
    extends ICreateOrderRequest,
        ICustomerUser {}

/* Response */

export interface ICreateOrder {
    orderId: string;
}

export type TCreateOrderResponse = IBaseSuccessResponse<ICreateOrder>;

/* Error response */

export interface IOrderError {
    code: BookingStatusesType;
    offerInfo?: IBookOffer;
}

export interface ICreateOrderError {
    error: IOrderError;
    statusCode: StatusCodes;
}

export type TCreateOrderErrorResponse = IBaseErrorResponse<ICreateOrderError>;
