import {IYandexEdaPromocodePayload} from 'server/api/OrdersAPI/types/TOrdersGetOrderHappyPageApiResponse';

import {IOfferYandexPlusInfo} from '../offer/IHotelOffer';

export interface IPromoCampaigns {
    taxi2020?: ITaxi2020PromoCampaignInfo;
    mir2020?: IMirCashbackPromoCampaignInfo;
    /* Информация об использовании баллов Плюса. При отсутствии функциональность недоступна. */
    yandexPlus?: IYandexPlusCampaignInfo;
    yandexEda?: IYandexEdaPromoCampaignInfo;
}

interface ITaxi2020PromoCampaignInfo {
    eligible: boolean;
}

interface IMirCashbackPromoCampaignInfo {
    eligible: boolean;
    cashbackAmount: number | null;
    cashbackAmountString: string;
}

export interface IYandexPlusCampaignInfo extends IOfferYandexPlusInfo {
    /* количество баллов, доступных для списания; отсутствует, если списание недоступно */
    withdrawPoints?: number;
}

export interface IYandexEdaPromoCampaignInfo {
    eligible: boolean;
    data: IYandexEdaPromocodePayload;
}
