export interface ISeoInfo<T> {
    /** Title страницы */
    title: string;
    /** Description страницы */
    description: string;
    /** OpenGraph-разметка */
    openGraph: IOpenGraphInfo;
    /** SchemaOrg-разметка */
    schemaOrg: T;
}

/* Opengraph-разметка страницы */
export interface IOpenGraphInfo {
    // URL страницы, для тэга og:url формируется фронтом, чтобы не нагружать бэк знанием формата урла

    /** OpenGraph Title страницы, для тэгов og:title и twitter:title */
    title: string;
    /** OpenGraph Description страницы, для тэгов og:description и twitter:description */
    description: string;
    /** OpenGraph картинка страницы, для тэга og:image */
    image?: string;
    /** OpenGraph размер картинки страницы, для тэга og:image:width и og:image:height */
    imageSize?: {
        width: number;
        height: number;
    };
}
