import {IHotelWithMinPrice} from 'types/hotels/hotel/IHotelWithMinPrice';
import {TSortId} from 'types/hotels/search/ISortInfo';
import {IFilterParams} from 'types/hotels/search/IFiltersInfo';
import {HotelSlugType} from 'types/hotels/hotel/IHotel';
import {GeoIdType} from 'types/hotels/hotel/IGeoRegion';
import {
    ETextBlocksType,
    ISectionTextBlock,
} from 'types/common/seoPages/ITextBlocks';
import {IBreadcrumbs} from 'server/api/HotelSearchAPI/types/IHotelBreadcrumbs';
import {IExtraVisitAndUserParams} from 'types/hotels/common/IExtraVisitAndUserParams';

import {IGeoRegionSeoInfo} from './ISeoInfo';

/* SearchForm Block */
export interface ISearchFormBlock {
    type: EGeoRegionBlockType.searchFormBlock;
    data: {
        imageUrl: string;
        title: string;
        searchFormParams: {
            isCalendarOpen: boolean;
            regionSlug: TGeoRegionSlug;
        };
        filterParams?: IFilterParams;
    };
}

/* Hotels Block */
export interface IHotelsBlock {
    type: EGeoRegionBlockType.hotelsBlock;
    data: {
        title: string;
        hotels: IHotelWithMinPrice[];
        searchButtonText: string;
        searchParams: ISearchPageIdentifyParams;
    };
}

export interface ISearchPageIdentifyParams {
    geoId?: GeoIdType;
    selectedSortId?: TSortId;
    filterParams?: IFilterParams;
}

/* Link blocks */
export interface IHotelLinkBlock {
    type: ETextBlocksType.hotelLinkBlock;
    data: {
        text: string;
        urlParams: {
            hotelSlug: HotelSlugType;
        };
    };
}

export interface IRegionLinkBlock {
    type: ETextBlocksType.regionLinkBlock;
    data: {
        text: string;
        urlParams: {
            regionSlug: TGeoRegionSlug;
            filterSlug?: string;
        };
    };
}

export interface ISearchHotelsLinkBlock {
    type: ETextBlocksType.searchHotelsLinkBlock;
    data: {
        text: string;
        urlParams: ISearchPageIdentifyParams;
    };
}

export interface IBreadcrumbsBlock {
    type: EGeoRegionBlockType.breadcrumbsBlock;
    data: {
        breadcrumbs: IBreadcrumbs;
    };
}

/**
 * Блок ссылок на страницы региона с фильтрами. Отображается на странице региона без фильтра
 * На десктопе располагается в левой части
 */
export interface IRegionLinkSetBlock {
    type: EGeoRegionBlockType.regionLinkSetBlock;
    data: {
        /**
         * Заголовок h2
         */
        title: string;
        /**
         * Массив подгрупп ссылок. Не пустой
         */
        subsets: IRegionLinkSubSetBlock[];
    };
}

interface IRegionLinkSubSetBlock {
    type: EGeoRegionBlockType.regionLinkSubSetBlock;
    data: {
        /**
         * Заголовок h3
         */
        title: string;
        /**
         * Массив ссылок. Не пустой
         */
        links: IRegionLinkBlock[];
    };
}

/* Main */
export type TGeoRegionSlug = string;
export type TFilterSlug = string;
export type TGeoRegionBlock =
    | ISearchFormBlock
    | IHotelsBlock
    | ISectionTextBlock
    | IBreadcrumbsBlock
    | IRegionLinkSetBlock;

export enum EGeoRegionBlockType {
    searchFormBlock = 'ISearchFormBlock',
    hotelsBlock = 'IHotelsBlock',
    breadcrumbsBlock = 'IBreadcrumbsBlock',
    regionLinkSetBlock = 'IRegionLinkSetBlock',
    regionLinkSubSetBlock = 'IRegionLinkSubSetBlock',
}

export interface IGeoRegionInfo {
    seoInfo: IGeoRegionSeoInfo;
    blocks: TGeoRegionBlock[];
    extraVisitAndUserParams: IExtraVisitAndUserParams;
}
