import {ICoordinates} from 'types/common/ICoordinates';

import {ITransportStation} from './ITransportStation';
import {HotelImagesType} from './IHotelImages';

export enum MainAmenityIdType {
    WI_FI = 'wi_fi',
    POOL = 'pool',
    CAR_PARK = 'car_park',
    AIR_CONDITIONING = 'air_conditioning',
    GYM = 'gym',
    PAYMENT_BY_CARD = 'payment_by_credit_card',
    BEACH_LINE = 'beach_line',
    AIR_DISINFECTION = 'covid_hotel_safety_air_disinfection',
    SANITIZERS = 'covid_hotel_safety_sanitizers',
    THERMOMETRY = 'covid_hotel_safety_thermometry',
    PERSONAL_PROTECTIVE_GEAR = 'covid_hotel_safety_employees_use_personal_protective_gear',
    SAFETY_MARKING_FLOOR = 'covid_hotel_safety_marking_floor',
}

export interface IHotel {
    permalink: PermalinkType;
    hotelSlug: HotelSlugType;
    name: string;
    category: IHotelCategory;
    coordinates: ICoordinates;
    address: string;
    stars?: number;
    rating: number | null;
    totalTextReviewCount: number;
    totalImageCount: number;
    images: HotelImagesType;
    nearestStations?: ITransportStation[];
    mainAmenities?: IMainHotelOrRoomAmenity[];
    amenityGroups?: IHotelAmenitiesGroup[];
    distanceMeters?: number;
    distanceText?: string;
    /**
     * Населённый пункт, в котором находится отель
     * Отображается на SEO странице региона вместо информации о ближайших остановках транспорта
     * @example "г. Сергиев Посад"
     * */
    location?: string;
    geoFeature?: IHotelGeoFeature | null;
    /*
     * Содержится ли отель в избранном
     */
    isFavorite: boolean;
    isYandexHotel?: boolean;
}

/* Permalink */
export type PermalinkType = string;

/* Slug */
export type HotelSlugType = string;

/* HotelIdentifier params */
export interface IHotelIdentifier {
    permalink?: PermalinkType;
    hotelSlug?: HotelSlugType;
}

/** Группа фичей отеля */
export interface IHotelAmenitiesGroup {
    id: string;
    name: string;
    amenities: IHotelOrRoomAmenity[];
}

/* HotelOrRoomAmenity */
export interface IHotelOrRoomAmenity {
    id: string;
    name: string;
}

export interface IMainHotelOrRoomAmenity {
    /** Id. Машино-читаемая строка. На её основе рисуется иконка.  */
    id: MainAmenityIdType;
    /** Человеко-читаемое название. Для отрисовки.
     * Пример: "химчиста", "душ", "парковка". */
    name: string;
}

/* HotelCategory */
export interface IHotelCategory {
    id: string;
    name: string;
}

export enum EHotelGeoFeatureIcon {
    CITY_CENTER = 'city-center',
    SEA = 'sea',
    PARK = 'park',
    AIRPORT = 'airport',
}

export interface IHotelGeoFeature {
    /**
     * Уникальный id геофичи
     */
    id: string;

    /**
     * Идентификатор иконки для отрисовки
     */
    icon: EHotelGeoFeatureIcon;

    /**
     * Строковое представление геофичи (например, "1км от центра" или "Рядом аэропорт")
     */
    name: string;
}
