import {DateTimeType} from 'types/hotels/common/IDate';

import {IHotelOrRoomImage} from './IHotelImages';

export interface ITextReview {
    id: string;
    text: string;
    updatedAt: DateTimeType;
    author?: ITextReviewAuthor;
    rating: number;
    totalLikeCount: number;
    totalDislikeCount: number;
    userReaction: UserReactionType;
    businessComment?: IBusinessComment;
    moderation?: ITextReviewModeration;
    keyPhraseMatch?: IKeyPhraseMatch;
    images?: IHotelOrRoomImage[];
}

export enum ETextReviewModerationStatus {
    ACCEPTED = 'ACCEPTED',
    DECLINED = 'DECLINED',
    PENDING = 'PENDING',
}
export interface ITextReviewModeration {
    status: ETextReviewModerationStatus;
    keyPhraseMatch?: IKeyPhraseMatch;
}

export interface IKeyPhraseMatchFragment {
    /** Начальная позиция фрагмента */
    position: number;
    /** Размер фрагмента */
    size: number;
}

export interface IKeyPhraseMatch {
    /** Список фрагментов, совпадающих с ключевым словов */
    fragments: IKeyPhraseMatchFragment[];
}

export interface ITextReviewAuthor {
    name: string;
    level: string;
    avatarUrl?: string;
    profileUrl: string;
}

export enum UserReactionType {
    NONE = 'NONE',
    LIKE = 'LIKE',
    DISLIKE = 'DISLIKE',
}

export interface IHotelReviewReaction {
    reviewId: string;
    userReaction: UserReactionType;
}

export interface IBusinessComment {
    id: string;
    text: string;
    updatedAt: DateTimeType;
}

/* KeyPhrases */
export interface IKeyPhrase {
    name: string;
    reviewCount: number;
}
