import {IHotel} from 'types/hotels/hotel/IHotel';
import {IHotelOrOfferBadge} from 'types/hotels/offer/IHotelOffer';

import IPrice from 'utilities/currency/PriceInterface';

export interface IHotelWithMinPrice {
    /** Параметры отеля */
    hotel: IHotel;
    /** Минимальная цена за количество ночей = nights */
    minPrice: IPrice;
    /** Количество ночей. Если отсутствует то считаем, что цена за 1 ночь */
    nights?: number;
    /** Бэджики отеля */
    badges?: IHotelOrOfferBadge[];
    /** Признак: участвует ли отель в программе кэшбэка от Яндекс.Плюс **/
    hasOfferYandexPlus?: boolean;
}
