import {IHotel, PermalinkType} from './IHotel';
import {IHotelOffer, IHotelOrOfferBadge} from '../offer/IHotelOffer';

export interface IHotelWithOffers {
    hotel: IHotel;
    searchIsFinished: boolean;
    searchedByUser?: boolean;
    offers?: IHotelOffer[];
    badges?: IHotelOrOfferBadge[];
}

export type THotelWithOffersByPermalink = Record<
    PermalinkType,
    IHotelWithOffers
>;

export interface IShortHotelOffersInfo {
    searchIsFinished: boolean;
    offers?: IHotelOffer[];
    badges?: IHotelOrOfferBadge[];
}
