import {ISeoInfo} from 'types/hotels/common/ISeoInfo';

export interface IHotelSeoInfo extends ISeoInfo<IHotelSchemaOrgInfo> {}

export interface IHotelSchemaOrgInfo {
    // URL страницы и URL карты формируется фронтом, чтобы не нагружать бэк знанием формата урла портала/карты

    /** Имя отеля
     * https://schema.org/name
     */
    name: string;

    /** абсолютный урл картинки отеля
     * https://schema.org/image
     */
    image: string;

    /** ценовой диапозон в формате 500р. - 1000р.
     *  https://schema.org/priceRange
     * Может отсутствовать, если неизвестен
     */
    priceRange?: string;

    /** адрес отеля
     * https://schema.org/address
     */
    address: string;

    /** Рейтинг. От 1 до 5. Дробное число, 1 знак после запятой.
     * https://schema.org/ratingValue
     */
    ratingValue: number;

    /** Число отзывов.
     * https://schema.org/reviewCount
     */
    reviewCount: number;
}
