import {ICoordinates} from 'types/common/ICoordinates';

export interface IMetroLine {
    id: string; // id линии "100000267"
    name: string; // "Первая линия"
    color?: string; // цвет линии в HEX, если доступен
}

export enum TransportStationType {
    METRO = 'METRO',
    OTHER = 'OTHER',
}

export interface ITransportStation {
    id: string; // id станции "station__9765108"
    type: TransportStationType;
    name: string; // "Площадь 1905г"
    coordinates: ICoordinates; // Расположение
    distanceMeters: number; // Расстояние в метрах, "1114.87"
    distanceText: string; // Человекочитаемое расстояние, "1,1 км"
    metroLine?: IMetroLine; // Если метро - то информация о линии
}
