import IPrice from 'utilities/currency/PriceInterface';

import {DateType} from '../common/IDate';
import {EPansionAggregate, IHotelOfferMeal} from './IHotelOfferMeal';
import {OperatorIdType} from './IHotelsOperator';
import {TRoomId} from './IHotelRoom';
import {
    ECancellationInfoAggregate,
    ICancellationInfo,
} from './IHotelOfferCancellationInfo';

export interface IHotelOffer {
    id: string;
    name: string;
    price: IPrice;
    roomId?: TRoomId;
    operatorId: OperatorIdType;
    landingUrl: string;
    token?: string;
    cancellationInfo?: ICancellationInfo;
    mealType?: IHotelOfferMeal;
    yandexOffer?: boolean;
    badges?: IHotelOrOfferBadge[];
    discountInfo?: IDiscountInfo;
    offerYandexPlusInfo?: IOfferYandexPlusInfo;
}

export interface IAggregatedOfferInfo {
    /** Минимальная цена по всем офферам */
    minPrice: IPrice;

    /** Максимальная цена по всем офферам */
    maxPrice: IPrice;

    /** Агрегированная информация о наличии питания в офферах. Если отсутствует - не рисуем соответствующую надпись. */
    pansionAggregate?: EPansionAggregate;

    /** Агрегированная информация о наличии отменяемых предложений в офферах. Если отсутствует - не рисуем соответствующую надпись. */
    cancellationInfoAggregate?: ECancellationInfoAggregate;
}

export interface IHotelOfferSearchProgress {
    finished: boolean;
    partnersTotal: number;
    partnersComplete: number;
}

export interface IHotelOfferSearchProgressInfo {
    offerSearchProgress: IHotelOfferSearchProgress;
    nextPollingRequestDelayMs?: number;
}

export interface IRequiredOfferParams {
    checkinDate: DateType;
    checkoutDate: DateType;
    adults: number;
    childrenAges: number[];
}

export interface IDebugOfferSearchParams {
    debugPortalHost: string;
    debugUseProdOffers: boolean;
}

export enum EHotelBadgeType {
    HOTEL_DIRECT = 'hotel_direct',
    HOTEL_ADS = 'ads',
    TAXI_PROMOCODE = 'taxi_promocode',
    MIR_CASHBACK = 'mir_cashback',
    WELCOME_PROMOCODE = 'welcome_promocode',
    YANDEX_EDA = 'yandex_eda',
}

export enum DiscountReason {
    YANDEX_HOTEL = 'YANDEX_HOTEL', // Скидка в Я.Отель, a.k.a. Будапешт
}

export interface IDiscountInfo {
    /* Базовая цена (до скидки) */
    strikethroughPrice: IPrice;
    /* Процент скидки по шкале от 0 до 100. Может отсутствовать, если скидка не выражается в процентах */
    percent?: string | number;
    /* Причина возникновения скидки. Может отсутствовать, если причина скидки неизвестна */
    reason?: DiscountReason;
}

export interface IHotelOrOfferBadge {
    id: EHotelBadgeType;
    text: string;
    additionalPromoInfo?: {
        title?: string;
        text: string;
        link?: {
            text: string;
            url: string;
        };
    };
}

// Предложения от партнеров
export interface IHotelPartnerOffer {
    /** Идентификатор оператора */
    operatorId: OperatorIdType;
    /** Агрегированная информация о наличии питания в предложениях этого партнёра. Если отсутствует - не рисуем соответствующую надпись. */
    pansionAggregate?: EPansionAggregate | null;
    /** Агрегированная информация о наличии отменяемых предложений у этого партнёра. Если отсутствует - не рисуем соответствующую надпись. */
    cancellationInfoAggregate?: ECancellationInfoAggregate | null;

    /** Этот оффер нужно показать в случае отображения только одной партнёрской цены */
    defaultOffer: IHotelOffer;

    /**
     * инфомация о типе питания из офера
     */
    defaultOfferPansion?: IHotelOfferMeal | null;

    /**
     * Информация об отмене из офера
     */
    defaultOfferCancellationInfo?: ICancellationInfo | null;
}

export interface IOfferYandexPlusInfo {
    /* количество баллов для начисления */
    points: number;
    /* True, если оффер участвет в акции: доступно начислены или списание; False если нет */
    eligible: boolean;
}

/**
 * Отражает результат применения промо-акции к заказу.
 * Может содержать результат выбора или иные данные, завязанные не на общий оффер, а на конкретный заказ.
 */
export interface IAppliedPromoCampaigns {
    yandexPlus?: IYandexPlusApplicationInfo;
}

/* описывает выбранный режим использования Плюса: начисление или списание и баллы */
export interface IYandexPlusApplicationInfo {
    mode: EYandexPlusApplicationMode;
    /* баллы, которые фактически начисляются или списываются */
    points: number;
}

export enum EYandexPlusApplicationMode {
    /* начисление */
    TOPUP = 'TOPUP',
    /* списание */
    WITHDRAW = 'WITHDRAW',
}
