import {TInstantDateTimeType} from 'types/common/date/IDate';

import IPrice from 'utilities/currency/PriceInterface';

export enum ERefundType {
    FULLY_REFUNDABLE = 'FULLY_REFUNDABLE',
    REFUNDABLE_WITH_PENALTY = 'REFUNDABLE_WITH_PENALTY',
    NON_REFUNDABLE = 'NON_REFUNDABLE',
}

export enum ECancellationInfoAggregate {
    FULLY_REFUNDABLE_AVAILABLE = 'FULLY_REFUNDABLE_AVAILABLE', // Есть варианты с бесплатной отменой
    REFUNDABLE_WITH_PENALTY_AVAILABLE = 'REFUNDABLE_WITH_PENALTY_AVAILABLE', // Есть варианты с отменой со штрафом
    NON_REFUNDABLE_AVAILABLE = 'NON_REFUNDABLE_AVAILABLE', // Доступны только неотменяемые предложения, отмена не предусмотрена
}

export interface IRefundRule {
    startsAt: TInstantDateTimeType;
    endsAt: TInstantDateTimeType;
    type: ERefundType;
    penalty?: IPrice;
}

export interface ICancellationInfo {
    hasFreeCancellation: boolean;
    refundType: ERefundType;
    refundRules?: IRefundRule[];
}
