import {EPansionAggregate} from 'types/hotels/offer/IHotelOfferMeal';
import {ECancellationInfoAggregate} from 'types/hotels/offer/IHotelOfferCancellationInfo';

import {IHotelOrRoomImage} from '../hotel/IHotelImages';
import {IHotelOrRoomAmenity} from '../hotel/IHotel';
import {IHotelOrOfferBadge} from './IHotelOffer';

export type TRoomId = string;

export enum ERoomAmenityIcon {
    AEROMASSAGE_BATH = 'aeromassage-bath',
    AIR_CONDITIONING = 'air-conditioning',
    BALCONY = 'balcony',
    BALCONY_OR_PATIO = 'balcony-or-patio',
    BALCONY_WITH_DECK_CHAIRS = 'balcony-with-deck-chairs',
    BALCONY_WITH_SIDE_SEA_VIEW = 'balcony-with-side-sea-view',
    BALCONY_WITH_VIEW = 'balcony-with-view',
    BARBECUE_FACILITIES = 'barbecue-facilities',
    BATHROOM = 'bathroom',
    BATHTUB = 'bathtub',
    BATHTUB_ONLY = 'bathtub-only',
    COFFEE_MACHINE = 'coffee-machine',
    DECK_OR_PATIO = 'deck-or-patio',
    DEEP_SOAKING_BATHTUB = 'deep-soaking-bathtub',
    FLAT_PANEL_TV = 'flat-panel-tv',
    FURNISHED_BALCONY = 'furnished-balcony',
    FURNISHED_BALCONY_OR_PATIO = 'furnished-balcony-or-patio',
    FURNISHED_LANAI = 'furnished-lanai',
    FURNISHED_PATIO = 'furnished-patio',
    HDTV = 'hdtv',
    JACUZZI_BATHROOM = 'jacuzzi-bathroom',
    JETTED_BATHTUB = 'jetted-bathtub',
    LANAI = 'lanai',
    LCD_TV = 'lcd-tv',
    LED_TV = 'led-tv',
    MINIBAR = 'minibar',
    MINIBAR_STOCKED_FREE_ITEMS = 'minibar-stocked-free-items',
    MINIBAR_STOCKED_SOME_FREE_ITEMS = 'minibar-stocked-some-free-items',
    PARTIALLY_OPEN_BATHROOM = 'partially-open-bathroom',
    PATIO = 'patio',
    PLASMA_TV = 'plasma-tv',
    PRIVATE_BATHROOM = 'private-bathroom',
    PRIVATE_BATHROOM_NOT_IN_ROOM = 'private-bathroom-not-in-room',
    PRIVATE_PLUNGE_POOL = 'private-plunge-pool',
    PRIVATE_POOL = 'private-pool',
    PRIVATE_SPA_TUB = 'private-spa-tub',
    PRIVATE_SPA_TUB_INDOOR = 'private-spa-tub-indoor',
    SECOND_BATHROOM = 'second-bathroom',
    SMOKING = 'smoking',
    SOUNDPROOFED_ROOMS = 'soundproofed-rooms',
    SPRING_WATER_BATHTUB = 'spring-water-bathtub',
    TELEVISION_SURCHARGE = 'television-surcharge',
    TELEVISION_YES = 'television-yes',
    THREE_TV_SETS = 'three-tv-sets',
    VIEW_BAY_VIEW = 'view-bay-view',
    VIEW_CITY_VIEW = 'view-city-view',
    VIEW_COURT_VIEW = 'view-court-view',
    VIEW_FOREST_VIEW = 'view-forest-view',
    VIEW_GARDEN_VIEW = 'view-garden-view',
    VIEW_LAKE_VIEW = 'view-lake-view',
    VIEW_MOUNTAIN_VIEW = 'view-mountain-view',
    VIEW_PARK_VIEW = 'view-park-view',
    VIEW_PARTIAL_SEAVIEW = 'view-partial-seaview',
    VIEW_POOL_VIEW = 'view-pool-view',
    VIEW_RIVER_VIEW = 'view-river-view',
    VIEW_SEA_VIEW = 'view-sea-view',
    VIEW_VIEW_RACE_TRACK = 'view-view-race-track',
    VIEW_VIEW_TO_STADIUM = 'view-view-to-stadium',
    WIFI = 'wifi',
}

export enum ERoomAmenityGroupIcon {
    KITCHEN = 'kitchen',
    BATHROOM = 'bathroom',
    FOOD = 'food',
    FURNITURE = 'furniture',
    ACCESSIBILITY = 'accessibility',
    CLOTHES = 'clothes',
    ELECTRONICS = 'electronics',
    SLEEP = 'sleep',
    ENTERTAINMENT = 'entertainment',
    INTERNET_TELEPHONY = 'internet-telephony',
    OUTSIDE_AREA_AND_VIEW = 'outside-area-and-view',
}

export interface IRoomAmenity {
    id: string;
    icon: ERoomAmenityIcon;
    name: string;
}

export interface IRoomAmenityGroup {
    id: string;
    icon: ERoomAmenityGroupIcon;
    name: string;
    amenities: IRoomAmenity[];
}

export enum ERoomBedIcon {
    SINGLE_BED = 'single_bed',
    DOUBLE_BED = 'double_bed',
}

export interface IRoomBedConfigurationItem {
    id: string;
    icon?: ERoomBedIcon;
    nameInitialForm: string;
    nameInflectedForm: string;
    quantity: number;
}

export interface IRoomBedGroup {
    id: string;
    configuration: IRoomBedConfigurationItem[];
}

export enum ERoomAreaUnits {
    SQUARE_METERS = 'SQUARE_METERS',
}

export interface IRoomArea {
    value: number;
    unit: ERoomAreaUnits;
}

export interface IHotelRoom {
    id: TRoomId;
    name: string;
    description?: string;
    images?: IHotelOrRoomImage[];
    amenities?: IHotelOrRoomAmenity[];
    mainAmenities?: IRoomAmenity[];
    amenityGroups?: IRoomAmenityGroup[];
    bedGroups?: IRoomBedGroup[];
    area?: IRoomArea;
    pansionAggregate?: EPansionAggregate | null;
    cancellationInfoAggregate?: ECancellationInfoAggregate | null;
    /** Бэйджи комнаты */
    badges?: IHotelOrOfferBadge[];
}
