import {Request} from '@yandex-data-ui/core/lib/types';
import {ICrossLink} from 'types/common/crossLinks/ICrossLink';
import {ETransport} from 'types/common/ETransport';

import {raspService} from 'serviceProvider';

export default async function requestCrossLinks({
    req,
    fromPointKey,
    toPointKey,
    transportType,
}: {
    req?: Request;
    fromPointKey: string;
    toPointKey: string;
    transportType: ETransport.TRAIN | ETransport.BUS;
}): Promise<ICrossLink[]> {
    return raspService.provider(req?.container).getCrossLinks({
        pointFrom: fromPointKey,
        pointTo: toPointKey,
        transportType: transportType,
    });
}
