import {Request} from '@yandex-data-ui/core/lib/types';
import {
    ITrainsGetDirectionSearchApiParams,
    ITrainsGetDirectionSearchApiResponse,
} from 'server/api/TrainsSearchApi/types/ITrainsGetDirectionSearch';

import {trainsService} from 'serviceProvider';

export default async function requestDirectionSearch({
    req,
    params,
}: {
    req?: Request;
    params: ITrainsGetDirectionSearchApiParams;
}): Promise<ITrainsGetDirectionSearchApiResponse> {
    return trainsService.provider(req?.container).getDirectionSearch(params);
}
