class AppData {
    private _appData?: IAppData;

    set data(appData: IAppData) {
        this._appData = appData;
    }

    getByKey(key: keyof IAppData) {
        return this._appData?.[key];
    }

    get isProductionEnv(): boolean {
        return this._appData?.appEnv === 'production';
    }
}

export default new AppData();
