import chunk from 'lodash/chunk';

/**
 * Разбивает массив на n групп.
 *
 * @param array - Массив, который нужно разделить на `n` групп.
 * @param n - Количество групп, на которое нужно разделить массив `array`.
 */
export default function groups<T>(array: Readonly<T[]>, n: number): T[][] {
    const size = Math.ceil(array.length / (n < 1 ? 1 : n));

    return chunk(array, size);
}
