import {delay as delayFunc} from './delay';

interface IRetryOptions {
    attempts?: number;
    delay?: number;
}

export function retry<A, R>(
    func: (...args: A[]) => R,
    {attempts = 3, delay = 1000}: IRetryOptions = {},
) {
    return async function (...args: A[]): Promise<R> {
        let count = 0;
        let error;

        while (count < attempts) {
            try {
                return await func(...args);
            } catch (e) {
                error = e;
            }

            await delayFunc(delay);

            count++;
        }

        throw error;
    };
}
