import {IAsyncDataState} from 'types/IAsyncDataState';

export function getAsyncDataInitialState<T>(
    initialValue: T,
): IAsyncDataState<T> {
    return {
        data: initialValue,
        isFetched: false,
        isFetching: false,
        isError: false,
    };
}

export function getAsyncDataFetchingState<T>(
    currentData: T,
): IAsyncDataState<T> {
    return {
        data: currentData,
        isFetching: true,
        isFetched: false,
        isError: false,
    };
}

export function getAsyncDataSuccessState<T>(data: T): IAsyncDataState<T> {
    return {
        data,
        isFetching: false,
        isFetched: true,
        isError: false,
    };
}

export function getAsyncDataErrorState<T>(defaultValue: T): IAsyncDataState<T> {
    return {
        data: defaultValue,
        isFetching: false,
        isFetched: true,
        isError: true,
    };
}
