import {TUserInfo} from 'reducers/common/commonReducerTypes';

import {isAuthUser} from 'utilities/userInfo/isAuthUser';

export const DEFAULT_AVATAR_ID = '0/0-0';

export default function getAvatarUrl(userInfo: TUserInfo): string {
    return isAuthUser(userInfo) ? userInfo.avatar.default : DEFAULT_AVATAR_ID;
}
