import {EHotelImageYapicSize} from 'types/hotels/common/EHotelImageYapicSize';

interface IGetAvatarUrlOptions {
    retina?: boolean;
}

export default function getAvatarUrl(
    avatarPath: string,
    avatarId: string,
    options?: IGetAvatarUrlOptions,
): string {
    if (options?.retina) {
        return `${avatarPath}/get-yapic/${avatarId}/${EHotelImageYapicSize.RETINA_MIDDLE}`;
    }

    return `${avatarPath}/get-yapic/${avatarId}/${EHotelImageYapicSize.MIDDLE}`;
}
