interface ICopyToClipboardParams {
    /**
     * Текст, который скопируется в буфер обмена
     */
    text: string;
}

export default async function copyToClipboard({
    text,
}: ICopyToClipboardParams): Promise<boolean> {
    try {
        await navigator.clipboard.writeText(text);

        return true;
    } catch (e) {
        return false;
    }
}
