import {StoreInterface} from 'reducers/storeTypes';

import {CSRFTokenType, getCSRFToken} from 'selectors/common/getCSRFToken';

import {
    prepareTokenHeader,
    ITokenHeader,
} from 'utilities/csrfToken/prepareTokenHeader';

export interface ICSRFGlobalGetter {
    readonly tokenHeader: ITokenHeader;
    readonly token: CSRFTokenType;
}

let token: CSRFTokenType;
let inited = false;

export const csrf: ICSRFGlobalGetter = {
    get tokenHeader() {
        return prepareTokenHeader(this.token);
    },

    get token() {
        if (!inited) {
            throw new Error('Csrf token has not yet been initialized');
        }

        return token;
    },
};

export function createGlobalTokenGetter(
    initilStoreState: StoreInterface,
): void {
    token = getCSRFToken(initilStoreState);
    inited = true;
}
