import {CSRF_TOKEN_HEADER_NAME} from 'constants/common';

import {CSRFTokenType} from 'selectors/common/getCSRFToken';

export interface ITokenHeader {
    [CSRF_TOKEN_HEADER_NAME]: CSRFTokenType;
}

export function prepareTokenHeader(csrfToken: CSRFTokenType): ITokenHeader {
    return {
        [CSRF_TOKEN_HEADER_NAME]: csrfToken,
    };
}
