import {formatDurationTime} from '../formatDurationTime';

describe('formatDurationTime', () => {
    it.each([
        [0, ''],
        [1, '1 секунда'],
        [3, '3 секунды'],
        [5, '5 секунд'],
        [15, '15 секунд'],
        [60, '1 минута'],
        [60 + 1, '1 минута 1 секунда'],
        [60 + 3, '1 минута 3 секунды'],
        [60 + 5, '1 минута 5 секунд'],
        [60 + 15, '1 минута 15 секунд'],
        [2 * 60, '2 минуты'],
        [2 * 60 + 5, '2 минуты 5 секунд'],
        [60 * 60, '1 час'],
        [3 * 60 * 60, '3 часа'],
        [5 * 60 * 60, '5 часов'],
        [9 * 60 * 60, '9 часов'],
        [100 * 60 * 60, '100 часов'],
    ])(
        'Если передать %p секунд ожидается вывод %p',
        (seconds, expectedString) => {
            expect(formatDurationTime(seconds)).toBe(expectedString);
        },
    );

    it.each([
        [0, ''],
        [15, ''],
        [60, '1 минута'],
        [60 + 15, '1 минута'],
        [2 * 60, '2 минуты'],
        [2 * 60 + 5, '2 минуты'],
        [60 * 60, '1 час'],
        [3 * 60 * 60 + 5 * 60 + 15, '3 часа 5 минут'],
        [9 * 60 * 60, '9 часов'],
        [100 * 60 * 60, '100 часов'],
    ])(
        'Если передать %p секунд ожидается вывод %p c precision == minutes',
        (seconds, expectedString) => {
            expect(formatDurationTime(seconds, {precision: 'minutes'})).toBe(
                expectedString,
            );
        },
    );

    it.each([
        [0, ''],
        [15, ''],
        [60, ''],
        [60 + 15, ''],
        [2 * 60, ''],
        [2 * 60 + 5, ''],
        [60 * 60, '1 час'],
        [3 * 60 * 60 + 5 * 60 + 15, '3 часа'],
        [9 * 60 * 60, '9 часов'],
        [100 * 60 * 60, '100 часов'],
    ])(
        'Если передать %p секунд ожидается вывод %p c precision == hours',
        (seconds, expectedString) => {
            expect(formatDurationTime(seconds, {precision: 'hours'})).toBe(
                expectedString,
            );
        },
    );

    it.each([
        [0, ''],
        [1, '1 секунду'],
        [3, '3 секунды'],
        [5, '5 секунд'],
        [15, '15 секунд'],
        [60, '1 минуту'],
        [60 + 1, '1 минуту 1 секунду'],
        [60 + 3, '1 минуту 3 секунды'],
        [60 + 5, '1 минуту 5 секунд'],
        [60 + 15, '1 минуту 15 секунд'],
        [2 * 60, '2 минуты'],
        [2 * 60 + 5, '2 минуты 5 секунд'],
        [60 * 60, '1 час'],
        [3 * 60 * 60, '3 часа'],
        [5 * 60 * 60, '5 часов'],
        [9 * 60 * 60, '9 часов'],
        [100 * 60 * 60, '100 часов'],
    ])(
        'Если передать %p секунд ожидается вывод %p for accusativeCase',
        (seconds, expectedString) => {
            expect(
                formatDurationTime(seconds, {linguistic: 'accusativeCase'}),
            ).toBe(expectedString);
        },
    );
});
