import moment, {unitOfTime} from 'moment';

import floorDuration from './utilities/floorDuration';
import getDurationUnitTextFunction from 'utilities/dateUtils/formatDurationTime/utilities/getDurationUnitTextFunction';

interface IFormatDurationTimeOptions {
    precision?: unitOfTime.Base;
    linguistic?: 'accusativeCase' | 'nominativeCase';
}

export function formatDurationTime(
    seconds: number,
    options: IFormatDurationTimeOptions = {},
): string {
    const {precision, linguistic = 'nominativeCase'} = options;

    const duration = moment.duration(seconds, 'seconds');
    const durationWithPrecision = precision
        ? floorDuration(duration, precision)
        : duration;

    const parts = [
        {
            text: getDurationUnitTextFunction('hours', linguistic),
            value: Math.floor(durationWithPrecision.asHours()),
        },
        {
            text: getDurationUnitTextFunction('minutes', linguistic),
            value: durationWithPrecision.minutes(),
        },
        {
            text: getDurationUnitTextFunction('seconds', linguistic),
            value: durationWithPrecision.seconds(),
        },
    ];

    return parts
        .filter(p => p.value > 0)
        .map(p => p.text({count: p.value}))
        .join(' ');
}
