import moment, {unitOfTime} from 'moment';

/**
 * Отбрасывает часть duration по precision
 */
export default function floorDuration(
    duration: moment.Duration,
    precision: unitOfTime.Base,
): moment.Duration {
    const milliseconds = duration.asMilliseconds();
    const roundUnitMilliseconds = moment
        .duration(1, precision)
        .asMilliseconds();

    const rounded = Math.floor(milliseconds / roundUnitMilliseconds);

    return moment.duration(rounded * roundUnitMilliseconds, 'milliseconds');
}
