import moment from 'moment';

import {HUMAN_NBSP, DATE} from 'utilities/dateUtils/formats';
import {CHAR_EM_DASH, CHAR_NBSP} from 'utilities/strings/charCodes';

export function formatPeriod(
    dateForward: string,
    dateBackward?: string,
): string {
    const forward = moment.utc(dateForward);

    if (!dateBackward) {
        return forward.format(HUMAN_NBSP);
    }

    const backward = moment.utc(dateBackward);

    const isSameMonth = forward.isSame(backward, 'month');

    const forwardFormat = isSameMonth ? DATE : HUMAN_NBSP;
    const delimeter = `${CHAR_NBSP}${CHAR_EM_DASH}${
        isSameMonth ? CHAR_NBSP : ' '
    }`;

    return `${forward.format(forwardFormat)}${delimeter}${backward.format(
        HUMAN_NBSP,
    )}`;
}
