import moment from 'moment';

import {getStartOfDate} from 'projects/trains/lib/date/utils';

import {MOMENT, HUMAN_DATE_RU} from './formats';

/**
 * Метод возвращает возраст пассажира на момент отправки
 *
 * @param birthDate - дата рождения
 * @param departure - время отправления
 * @param birthDateFormat - формат даты рождения. По умолчанию: 'DD.MM.YYYY'
 */
export function getBoardingAge(
    birthDate: string,
    departure: string,
    birthDateFormat?: string,
): number {
    const departureMoment = getStartOfDate(moment(departure, MOMENT));
    const date = moment(birthDate, birthDateFormat || HUMAN_DATE_RU);

    return departureMoment.diff(date, 'years', true);
}
