import moment, {Moment} from 'moment';

import {IDateOffset} from 'types/common/validation/validation';

import {DateLikeType} from './index';

function getDateWithOffset(
    date: DateLikeType,
    dateOffset: IDateOffset,
    format?: string,
): Moment {
    const {offset, scale} = dateOffset;
    const dependentDate = moment(date, format);

    dependentDate.add(offset, scale);

    return dependentDate;
}

export default getDateWithOffset;
