/**
 * Получение массива дат по начальной и конечной датам
 * Т.к. для скорости используется нативный Date, то параметры должны быть с ним совместимы
 */
export function getDaysPeriod(params: {from: string; to: string}): string[] {
    const period = [];

    const from = new Date(params.from);
    const to = new Date(params.to);

    // eslint-disable-next-line no-unmodified-loop-condition
    while (from <= to) {
        period.push(
            [
                from.getFullYear(),
                `${from.getMonth() + 1}`.padStart(2, '0'),
                `${from.getDate()}`.padStart(2, '0'),
            ].join('-'),
        );
        from.setDate(from.getDate() + 1);
    }

    return period;
}
