import moment from 'moment';

import IRoundTripDate from 'types/common/date/IRoundTripDate';
import ICalendarDate from 'types/common/date/ICalendarDate';

import {isHoliday} from 'utilities/dateUtils/isHoliday';
import getDateRobotFromMoment from 'utilities/dateUtils/getDateRobotFromMoment';
import {TInterval} from 'projects/avia/components/Dynamics/utilities/getAviaDynamicsCalendarDates';

/**
 * Возвращает даты путешествий для переданного интервала
 */
export default function getRoundTripDatesByInterval(
    interval: TInterval,
    dayDelta: number | null,
): IRoundTripDate[] {
    const dates: IRoundTripDate[] = [];

    const forwardMoment = moment(interval.startDate);
    const endMoment = moment(interval.endDate);

    while (forwardMoment.isSameOrBefore(endMoment)) {
        let dateBackward: ICalendarDate | null = null;

        if (dayDelta !== null) {
            const backwardMoment = forwardMoment.clone().add(dayDelta, 'days');

            dateBackward = {
                date: getDateRobotFromMoment(backwardMoment),
                isHoliday: isHoliday(backwardMoment),
            };
        }

        const roundTripDate: IRoundTripDate = {
            dateForward: {
                date: getDateRobotFromMoment(forwardMoment),
                isHoliday: isHoliday(forwardMoment),
            },
            dateBackward,
        };

        dates.push(roundTripDate);

        forwardMoment.add(1, 'day');
    }

    return dates;
}
