import {Moment} from 'moment';
import {get} from 'lodash';

import HOLIDAYS from 'src/prerequisites/holidays/holidays.json';

import {
    SATURDAY_INDEX,
    SUNDAY_INDEX,
    NEXT_SUNDAY_INDEX,
} from 'components/Calendar/constants/constants';

import {ROBOT} from 'utilities/dateUtils/formats';

/**
 * Возвращает признак того, что данный день выходной (суббота, воскресенье) или праздничный
 * @param momentDate
 */
export function isHoliday(momentDate: Moment): boolean {
    const dateStr = momentDate.format(ROBOT);

    const isCalendarHoliday = get(
        HOLIDAYS,
        dateStr,
        // т.к HOLIDAYS может вернуть false (например рабочие суббота или воскресение)
        undefined,
    );

    if (isCalendarHoliday !== undefined) {
        return isCalendarHoliday;
    }

    const dayOfWeek = momentDate.day();

    switch (dayOfWeek) {
        case SATURDAY_INDEX:
        case SUNDAY_INDEX:
        case NEXT_SUNDAY_INDEX:
            return true;
    }

    return false;
}
