import moment, {Moment} from 'moment-timezone';

import {WHEN_SPECIAL_VALUE} from 'types/common/When';

import isSpecialWhen from 'utilities/dateUtils/when/isSpecialWhen';
import getWhenMomentFromSpecialWhen from 'utilities/dateUtils/when/getWhenMomentFromSpecialWhen';

/**
 * Возвращает момент поиска по строке (Например: 2020-01-25, today, tomorrow).
 */
export default function getWhenMoment(
    when: string | WHEN_SPECIAL_VALUE,
    timezone?: string,
): Moment {
    if (isSpecialWhen(when)) {
        return getWhenMomentFromSpecialWhen(when, timezone);
    }

    if (timezone) {
        return moment.tz(when, timezone);
    }

    return moment(when);
}
