import moment, {Moment} from 'moment-timezone';

import {WHEN_SPECIAL_VALUE} from 'types/common/When';

import {getNow} from 'utilities/dateUtils';

export default function getWhenMomentFromSpecialWhen(
    when: WHEN_SPECIAL_VALUE,
    timezone?: string,
): Moment {
    const nowMoment = timezone
        ? moment(getNow()).tz(timezone)
        : moment(getNow());

    if (when === WHEN_SPECIAL_VALUE.TODAY) {
        return nowMoment;
    }

    if (when === WHEN_SPECIAL_VALUE.TOMORROW) {
        return nowMoment.add(1, 'days');
    }

    if (when === WHEN_SPECIAL_VALUE.AFTER_TOMORROW) {
        return nowMoment.add(2, 'days');
    }

    if (when === WHEN_SPECIAL_VALUE.NEXT_WEEK) {
        return nowMoment.add(1, 'week');
    }

    if (when === WHEN_SPECIAL_VALUE.NEXT_MONTH) {
        return nowMoment.add(1, 'month');
    }

    return nowMoment;
}
