import {isString, isObject, mapValues} from 'lodash';

import {templateReplacement} from 'utilities/templateReplacement';

export function deepReplace(
    target: unknown,
    replacement?: Record<string, string>,
): unknown {
    if (isString(target)) {
        return templateReplacement(target, replacement);
    }

    if (Array.isArray(target)) {
        return target.map(value => deepReplace(value, replacement));
    }

    if (isObject(target)) {
        return mapValues(target, value => deepReplace(value, replacement));
    }

    return target;
}
