import {documentFormats, EDocumentType} from 'constants/document/documentTypes';

import {maskFormat} from 'utilities/strings/maskFormat';

export function formatDocumentNumber(
    value: string,
    docType: EDocumentType,
): string {
    const formatter = documentFormats[docType];

    return formatter
        ? maskFormat(value, formatter.mask, formatter.placeholder)
        : value;
}
